class Student :
    def __init__(self,name,roll_no,age,city):
        self.name = name
        self.roll_no = roll_no
        self.age = age
        self.city = city
    
    def display_info(self):
        print(f"Name = {self.name}")
        print(f"Roll No = {self.roll_no}")
        print(f"Age = {self.age}")
        print(f"City = {self.city}")

class StudentManager:

    def __init__(self):
        self.students = {}

    def add_student(self,student):

        if student.roll_no not in self.students:
            self.students[student.roll_no] = student
            print("✅ Student added successfully.")
        else:
            print("⚠️   Student with this roll number already exists.")

    def update_student(self,roll_no,city):
        if roll_no not in self.students:
            print("⚠️ Student with this roll number does not exist.")
        else:
            self.students[roll_no].city = city
            print("✅ City updated successfully.")

    def delete_student(self,roll_no):
        if roll_no not in self.students:
           print("⚠️ Student with this roll number does not exist.")

        else:
            del self.students[roll_no]
            print("✅ Student deleted successfully.")

    def display_student(self,roll_no):
        if roll_no not in self.students:
            print("⚠️ Student with this roll number does not exist.")
        else:
            self.students[roll_no].display_info()

    def display_all_student(self):
        for i,j in self.students.items():
            j.display_info()
            print("--------------")

system = StudentManager()

def safe_input(message):
    while True:
        try:
            return int(input(message))
        except ValueError:
            print("⚠️ Invalid input. Please enter a number.")

while True:
    print("\n===== Student Management System =====")
    print("1. Add Student")
    print("2. Update Student")
    print("3. Delete Student")
    print("4. Display All Students")
    print("5. Exit")

    print("")
    choice = input("Enter your choice: ")
    print("")

    try:
        if choice == "1":
            name = input("Enter name: ")
            roll_no = safe_input("Enter Roll No: ")
            age = safe_input("Enter age: ")
            city = input("Enter city: ")
            s = Student(name, roll_no, age, city)
            system.add_student(s)

        elif choice == "2":
            roll_no = int(input("Enter roll no to update: "))
            city = input("Enter new city: ")
            system.update_student(roll_no, city)
            print("Updated student details:")
            system.display_student(roll_no)

        elif choice == "3":
            roll_no = int(input("Enter the roll no to delete: "))
            system.delete_student(roll_no)

        elif choice == "4":
            print("Displaying all students:")
            system.display_all_student()

        elif choice == "5":
            print("👋 Exiting Student Management System. Goodbye!")
            break

        else:
            print("❌ Invalid choice. Please try again.")

    except ValueError:
        print("⚠️ Invalid input. Please enter the correct data type.")
        pass